<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';
require_once '../includes/functions.php';

// Check if user is logged in and has permission
if (!isLoggedIn() || !hasPermission('manage_suppliers')) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit;
}

header('Content-Type: application/json');

try {
$supplier_id = intval($_GET['supplier_id'] ?? 0);
    
    if (!$supplier_id) {
        throw new Exception('Invalid supplier ID');
    }
    
    $query = "SELECT sr.id, sr.product_id, p.name as product_name, 
                     sr.quantity, sr.unit_price, sr.status
  FROM supplier_receipts sr
  JOIN products p ON sr.product_id = p.id
              WHERE sr.supplier_id = ? AND sr.status = 'approved'
              ORDER BY p.name";
              
    $stmt = $pdo->prepare($query);
$stmt->execute([$supplier_id]);
    
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode(['success' => true, 'items' => $items]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
} 